<?php

namespace Drupal\extend_info\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\system\Form\SiteInformationForm;


class ExtendedSiteInformationForm extends SiteInformationForm
{

	/**
	 * {@inheritdoc}
	 */
	public function buildForm(array $form, FormStateInterface $form_state)
	{
		$site_config = $this->config('system.site');
		$form =  parent::buildForm($form, $form_state);
		$form['site_information']['site_email'] = [
			'#type' => 'email',
			'#title' => t('Contact Email'),
			'#default_value' => $site_config->get('site_email'),
			'#description' => t("Email used to contact the company."),
		];
		$form['site_information']['site_phone'] = [
			'#type' => 'textfield',
			'#title' => t('Phone Number'),
			'#default_value' => $site_config->get('site_phone'),
			'#description' => t("Phone Number used to contact the company. <i>Note that dialer will automatically remove whitespace and everything starts with dash or hashtag.</i>"),
		];

		return $form;
	}

	public function submitForm(array &$form, FormStateInterface $form_state)
	{
		$this->config('system.site')
			->set('site_email', $form_state->getValue('site_email'))
			->set('site_phone', $form_state->getValue('site_phone'))
			->save();
		parent::submitForm($form, $form_state);
	}
}
