<?php

namespace BackupMigrate\Core\Source;

use BackupMigrate\Core\Plugin\FileProcessorInterface;
use BackupMigrate\Core\Plugin\FileProcessorTrait;
use BackupMigrate\Core\Plugin\PluginBase;

/**
 * Class SourceBase.
 *
 * @package BackupMigrate\Core\Source
 */
abstract class SourceBase extends PluginBase implements SourceInterface, FileProcessorInterface {
  use FileProcessorTrait;

  /**
   * {@inheritdoc}
   */
  public function supportedOps() {
    return [
      'exportToFile' => [],
      'importFromFile' => []
    ];
  }

}
